<?php
session_start();
require 'db.php';

if (!isset($_SESSION['user_id'])) {
    header("Location: login.php");
    exit();
}

if (!isset($_GET['calendar_id'])) {
    die("Kalendārs nav norādīts.");
}

$calendar_id = intval($_GET['calendar_id']);

// Pārbaudām, vai lietotājam ir piekļuve kalendāram
$stmt = $pdo->prepare("SELECT * FROM calendars WHERE id = ? AND user_id = ?");
$stmt->execute([$calendar_id, $_SESSION['user_id']]);
$calendar = $stmt->fetch();

if (!$calendar) {
    die("Jums nav piekļuves šim kalendāram.");
}

if ($_SERVER['REQUEST_METHOD'] == 'POST') {
    $title = trim($_POST['title']);
    $description = trim($_POST['description']);
    $start_time = trim($_POST['start_time']);
    $end_time = trim($_POST['end_time']);

    if (empty($title) || empty($start_time) || empty($end_time)) {
        die("Lūdzu aizpildiet visus laukus.");
    }

    // Formatējam datumu uz MySQL formātu
    $start_time = date("Y-m-d H:i:s", strtotime($start_time));
    $end_time = date("Y-m-d H:i:s", strtotime($end_time));

    $stmt = $pdo->prepare("INSERT INTO tasks (calendar_id, title, description, start_time, end_time) VALUES (?, ?, ?, ?, ?)");
    $stmt->execute([$calendar_id, $title, $description, $start_time, $end_time]);

    header("Location: dashboard.php");
    exit();
}
?>

<!DOCTYPE html>
<html lang="lv">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Pievienot uzdevumu</title>
    <link rel="stylesheet" href="styles.css">
    <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
</head>
<body>
<?php include 'header.php'; ?>

<h1>Pievienot uzdevumu kalendāram: <?php echo htmlspecialchars($calendar['name']); ?></h1>
<form method="POST">
    <label for="title">Nosaukums:</label>
    <input type="text" name="title" id="title" required>

    <label for="description">Apraksts:</label>
    <textarea name="description" id="description"></textarea>

    <label for="start_time">Sākuma laiks:</label>
    <input type="text" name="start_time" id="start_time" required>

    <label for="end_time">Beigu laiks:</label>
    <input type="text" name="end_time" id="end_time" required>

    <button type="submit">Pievienot</button>
</form>

<script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>
<script>
    flatpickr("#start_time", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true
    });

    flatpickr("#end_time", {
        enableTime: true,
        dateFormat: "Y-m-d H:i",
        time_24hr: true
    });
</script>

<?php include 'footer.php'; ?>
</body>
</html>
